/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.account;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.account.CapitalQueryBalanceResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version CapitalQueryBalanceRequest.java, v 0.1 2020-04-27 21:11
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CapitalQueryBalanceRequest extends VbillBizRequest<CapitalQueryBalanceResponse> {

    private static final long serialVersionUID = 5384640702654249279L;

    /**
     * 商编
     */
    @NotBlank
    private String mno;

    @Override
    public Class<CapitalQueryBalanceResponse> getResponseClass() {
        return CapitalQueryBalanceResponse.class;
    }
}