/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.sign;

import java.util.Map;

/**
 * @author wujn
 * @version Signer.java, v 0.1 2020-04-23 7:51 PM wujn
 */
public interface Signer {
    /**
     * 加签
     *
     * @param data
     * @param signType
     * @param privateKey
     * @return
     */
    String sign(Map<String, String> data, String signType, String privateKey);

    /**
     * 验签
     *
     * @param data
     * @param signType
     * @param sign
     * @param publicKey
     * @return
     */
    Boolean verifySign(Map<String, Object> data, String signType, String sign, String publicKey);
}
