/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.merchant;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import com.fshows.vbill.sdk.response.merchant.item.RepoInfoItem;
import com.fshows.vbill.sdk.response.merchant.item.SpInfoItem;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商户进件状态查询
 *
 * @author buhao
 * @version MerchantIncomdeQueryResponse.java, v 0.1 2020-06-08 10:55 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIncomeQueryResponse extends VbillBizResponse {
    private static final long serialVersionUID = -8280604071354735292L;
    /**
     * 进件申请ID
     */
    private String applicationId;
    /**
     * 商编
     */
    private String mno;
    /**
     * 审核状态
     * 取值:0入驻审核中
     * 1入驻通过
     * 2入驻驳回
     * 3入驻图片驳回
     * 说明:当审核状态是图片驳回时,
     * 调用商户入驻修改接口只能修改
     * 图片信息后重新提交
     */
    private Integer taskStatus;
    /**
     * 审核信息，驳回原因
     */
    private String suggestion;
    /**
     * 渠道报备信息
     * 以json的形式返回
     * childNoType:WX微信,ZFB
     * 支付宝
     * repoStatus:01成功,02失败
     * channelId:接入方渠道号
     * childNo:渠道子商户号
     * errMessage:报备失败原因
     */
    private List<RepoInfoItem> repoInfo;
    /**
     * 收单机构商编
     */
    private List<SpInfoItem> spInfo;
}