/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.WechatDishesSendResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yangdw
 * @version WechatQrorderSendRequest.java, v 0.1 2020-04-27 18:06
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WechatDishesSendRequest extends VbillBizRequest<WechatDishesSendResponse> {

    private static final long serialVersionUID = 601477005749282604L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 授权码
     */
    @NotBlank
    private String loginToke;

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 正交易天阙订单号(随行付订单号uuid)
     */
    private String outTradeNo;

    /**
     * 点餐入口
     */
    @NotBlank
    private String orderEntry;

    /**
     * 订单总额
     */
    @NotBlank
    private String orderTotalAmount;

    /**
     * 优惠金额
     */
    @NotBlank
    private String orderDiscountAmount;

    /**
     * 实际支付金额
     */
    @NotBlank
    private String orderUserAmount;

    /**
     * 订单状态
     * CREATE_DEAL:用户下单; PAY_SUCCESS:支付完成，结账成功;枚举值如上，二选其一
     */
    @NotBlank
    private String orderStatus;

    /**
     * 餐品信息
     */
    @NotNull
    private List<WechatDishesInfoRequest> dishList;

    @Override
    public Class<WechatDishesSendResponse> getResponseClass() {
        return WechatDishesSendResponse.class;
    }
}
