/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.MerchantSignResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version MerchantSignRequest.java, v 0.1 2020-04-29 13:57
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSignRequest extends VbillBizRequest<MerchantSignResponse> {

    private static final long serialVersionUID = -3298912034445283608L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    @Override
    public Class<MerchantSignResponse> getResponseClass() {
        return MerchantSignResponse.class;
    }
}