/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.CapitalFileUrlResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version CapitalFileUrlRequest.java, v 0.1 2020-04-27 21:03
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CapitalFileUrlRequest extends VbillBizRequest<CapitalFileUrlResponse> {

    private static final long serialVersionUID = -5881427484825056594L;

    /**
     * 对账单日期 (当天时间之前180天内的日期)
     */
    @NotBlank
    private String billDate;

    /**
     * 对账单类型
     * 00:交易 01:结算 02:分账
     */
    @NotBlank
    private String billType;

    @Override
    public Class<CapitalFileUrlResponse> getResponseClass() {
        return CapitalFileUrlResponse.class;
    }
}