/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantWechatPaySetQueryConfResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 微信子商户支付参数查询
 *
 * @author buhao
 * @version MerchantWechatPaySetQueryConfRequest.java, v 0.1 2020-06-12 11:20 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWechatPaySetQueryConfRequest extends VbillBizRequest<MerchantWechatPaySetQueryConfResponse> {
    /**
     * 商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;
    @NotBlank(message = "subMchId不能为空")
    private String subMchId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantWechatPaySetQueryConfResponse> getResponseClass() {
        return MerchantWechatPaySetQueryConfResponse.class;
    }
}