package com.fshows.vbill.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 交易相关API枚举
 *
 * @author liluqing
 * @version VbillTardeApiEnum.java, v 0.1 2020-06-08 12:15
 */
public enum VbillTardeApiEnum implements VbillBaseApi {
    /**
     * 枚举列表
     */
    ORDER_SCAN("C扫B,定额码支付接口", "/order/activeScan"),
    SCAN_ORDER("C扫B,刷卡支付接口", "/order/reverseScan"),
    JS_API_SCAN("B扫C,统一下单接口", "/order/jsapiScan"),
    ORDER_REFUND("订单退款接口", "/order/refund"),
    ORDER_QUERY("订单查询接口","/query/tradeQuery"),
    REFUND_QUERY("退款查询接口", "/query/refundQuery"),
    OPENID_QUERY("微信获取openid接口", "/query/getSubOPenid"),
    UNION_INFO_QUERY("获取银联用户标识接口", "/query/getUnionInfo"),
    ORDER_CANCEL("订单撤销接口", "/query/cancel"),
    ORDER_CLOSE("订单关闭接口", "/query/close"),
    POUNDAGE_QUERY("手续费查询", "/query/poundageQuery"),;

    private String name;
    private String value;

    VbillTardeApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    @Override
    public String getApiSubPath() {
        return value;
    }

    @Override
    public String getApiURL(String basePath) {
        return basePath + value;
    }

    public static VbillTardeApiEnum getByValue(String value) {
        VbillTardeApiEnum[] valueList = VbillTardeApiEnum.values();
        for (VbillTardeApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}