/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.merchant;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wujn
 * @version MerchantIncomeEditResponse.java, v 0.1 2020-06-05 9:00 AM wujn
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIncomeEditResponse extends VbillBizResponse {
    private static final long serialVersionUID = -7416758705570872800L;
    /**
     * 进件申请 ID
     * 进件唯一标识，用此参数通过
     * 商户入驻查询接口查询进件実
     * 核结果。
     */
    private String applicationId;
    /**
     * 返回码
     */
    private String bizCode;
    /**
     * 返回信息
     */
    private String bizMsg;
    /**
     * 商编
     * 接口响应 0000 成功时会返回
     * 返回商编。商户默认実核状态
     * 是実核中。需通过商户入驻结
     * 果查询接口查询実核结果。
     */
    private String mno;
}
