/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillOrderQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author wujn
 * @version OrderQueryRequest.java, v 0.1 2020-04-27 8:55 PM wujn
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class VbillOrderQueryRequest extends VbillBizRequest<VbillOrderQueryResponse> {
    private static final long serialVersionUID = -7037097227909845693L;
    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 支付宝或微信单号
     */
    private String transactionId;

    /**
     * 科技公司订单号
     */
    private String uuid;

    /**
     * TQ 机具编号，支付来源为硬件时，该参数为必传；
     */
    private String terminalId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 随行付商编
     */
    @NotBlank
    private String mno;

    @Override
    public Class<VbillOrderQueryResponse> getResponseClass() {
        return VbillOrderQueryResponse.class;
    }
}
