/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.LaunchLedgerResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author yangdw
 * @version LaunchLedgerParam.java, v 0.1 2020-04-24 09:58
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LaunchLedgerRequest extends VbillBizRequest<LaunchLedgerResponse> {

    private static final long serialVersionUID = 2584335263943350825L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 随行付订单号
     */
    private String uuid;

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 00:不分账 01:做分账
     */
    private String ledgerAccountFlag;

    /**
     * ledgerAccountFlag为00时该字段不传，
     * 资金除交易手续费外入到收款商户账户内;
     * 以上为01时该字段必传，上送为具体分账规则内容
     * 上送取消分账(ledgerAccountFlag=00)，除手续费外的所有交易资金都会进入交易主体的账户
     * 交易主体的账户不需要传递
     * [{"allotValue":0.01,"mno":399190618057330},{"allotValue":0.01,"mno":399190618057330}]
     */
    private List<LedgerItemRequest> ledgerRule;

    @Override
    public Class<LaunchLedgerResponse> getResponseClass() {
        return LaunchLedgerResponse.class;
    }
}