/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.WechatDishesTokenResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version WechatDishesTokenRequest.java, v 0.1 2020-04-27 17:18
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WechatDishesTokenRequest extends VbillBizRequest<WechatDishesTokenResponse> {

    private static final long serialVersionUID = 7404594403718475923L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 随行付订单号
     */
    @NotBlank
    private String uuid;

    /**
     * 接收异步回调地址
     */
    @NotBlank
    private String callBackUrl;

    @Override
    public Class<WechatDishesTokenResponse> getResponseClass() {
        return WechatDishesTokenResponse.class;
    }
}