/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.TransferAccountsResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version TransferAccountsRequest.java, v 0.1 2020-04-27 18:45
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TransferAccountsRequest extends VbillBizRequest<TransferAccountsResponse> {

    private static final long serialVersionUID = -7043184639684088100L;

    /**
     * 转入商编
     */
    @NotBlank
    private String mno;

    /**
     * 转出商编
     */
    @NotBlank
    private String fromMno;

    /**
     * 服务费出资方
     * 01:服务商出资; 02:商户出资
     */
    private String investor;

    /**
     * 商户转账订单号
     */
    @NotBlank
    private String orderNo;

    /**
     * 转账金额;单位元，保留两位小数
     */
    @NotBlank
    private String amount;

    /**
     * 备注
     */
    @NotBlank
    private String content;

    /**
     * 出资账户类型
     * 01：01户转出
     * 02：09户转出
     * (商户转商户不传此参数默认为09户转出；其他转账类型不传此参数默认为01户转出)
     */
    private String accountType;

    @Override
    public Class<TransferAccountsResponse> getResponseClass() {
        return TransferAccountsResponse.class;
    }
}