/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.TradePageResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version TradePageRequest.java, v 0.1 2020-04-27 16:31
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TradePageRequest extends VbillBizRequest<TradePageResponse> {

    private static final long serialVersionUID = 5226483413633067063L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 账单日期yyyyMMdd
     * 查询区间为当天到前30天
     */
    @NotBlank
    private String billTime;

    /**
     * 页数
     */
    @NotBlank
    private String page;

    @Override
    public Class<TradePageResponse> getResponseClass() {
        return TradePageResponse.class;
    }
}