/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.PoundageQueryResponse;
import lombok.Data;

/**
 * @author Liluqing
 * @version PoundageQueryRequest.java, v 0.1 2020-06-10 16:52
 */
@Data
public class PoundageQueryRequest extends VbillBizRequest<PoundageQueryResponse> {

    /**
     * 随行付商编
     */
    private String mno;

    /**
     * 正交易订单号
     */
    private String ordNo;

    /**
     * 原交易科技公司订单号
     */
    private String uuid;

    @Override
    public Class<PoundageQueryResponse> getResponseClass() {
        return PoundageQueryResponse.class;
    }
}