/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;

/**
 * 刷卡相应接口
 * 刷卡相应接口
 *
 * @author Liluqing
 * @version ScanCardResult.java, v 0.1 2020-04-22 12:12
 */
@Data
public class VbillScanCardResponse extends VbillBizResponse {

    /**
     * 微信 subAppId
     */
    private String subAppid;

    /**
     * 子商户号
     */
    private String subMechId;

    /**
     * 渠道商商户号
     */
    private String channelId;

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 科技公司订单号
     */
    private String uuid;

    /**
     * 支付场景，1：刷卡 2：声波3：刷脸
     * 不上传默认为 1
     */
    private String scene;

    /**
     * 交易支付完成时间
     */
    private String payTime;

    /**
     * 买家用户号支付宝渠道：买家支付宝用户号buyer_user_id微信渠道：
     * 微信平台的sub_openid
     */
    private String buyerId;
    /**
     * 支付宝买家帐号
     */
    private String buyerAccount;

    /**
     * 支付渠道，对订单的描述，取值范围：WECHAT: 微 信 ,ALIPAY: 支 付宝 ,UNIONPAY:银联
     */
    private String payType;

    /**
     * 支付方式00 主扫, 01被扫, 02 公众号 / 服务窗 ,03 小程序, 04app
     */
    private String payWay;

    /**
     * 商家实收(应结金额)
     */
    private String settleAmt;

    /**
     * 微信/支付宝流水号支付宝渠道：支付宝交易流水微信渠道：微信交易流水
     */
    private String transactionId;

    /**
     * 银联对账 key
     */
    private String reconKey;

    /**
     * 借贷记标识 1- 借,2-贷，3-其他
     */
    private String drType;

    /**
     * 消费者付款金额
     */
    private String totalOffstAmt;

    /**
     * 代金券金额积分支付金额，优惠金额或折扣券的金额
     */
    private String pointAmount;

    /**
     * 落单号，供退款和退款查询使用
     */
    private String sxfUuid;

    /**
     * 00: 线下标准 、 01: 线 上标准、 02: 蓝海 、 \
     * 03: 绿洲 、 04: 线 下缴费、 05: 线下 保 险 、
     * 06:线下非赢利、07: 高校食堂，08：私立院校，09：其他
     */
    private String activityNo;
    /**
     * 优惠信息（ jsonArray格式字符串）
     */
    private String promotionDetail;
}