/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import lombok.Data;

/**
 * @author Liluqing
 * @version GoodsDetailRequest.java, v 0.1 2020-04-28 14:09
 */
@Data
public class GoodsDetailRequest {

    /**
     * 商品编码
     */
    private String goodsId;

    /**
     * 微信/支付宝侧商品码
     */
    private String thirdGoodsId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品数量
     */
    private String quantity;

    /**
     * 商品单价,单元：元
     */
    private String price;
    /**
     * 商品类目-支付宝独有
     */
    private String goodsCategory;

    /**
     * 商品类目树， 从商品类目根节点到叶子节点的类目 id 组成，类目 id 值使用|分割
     */
    private String categoriesTree;

    /**
     * 商品描述； 支付宝独有
     */
    private String goodsDesc;

    /**
     * 商品展示地址url；支付宝独有
     */
    private String showUrl;
}