/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.TransferAccountsResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version TransferAccountsRequest.java, v 0.1 2020-04-27 18:45
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TransferAccountsRequest extends VbillBizRequest<TransferAccountsResponse> {

    private static final long serialVersionUID = -7043184639684088100L;

    /**
     * 转入商编
     */
    @NotBlank
    private String mno;

    /**
     * 转出商编
     */
    @NotBlank
    private String fromMo;

    /**
     * 服务费出资方
     * 01:服务商出资; 02:商户出资
     */
    private String investor;

    /**
     * 商户转账订单号
     */
    @NotBlank
    private String orderNo;

    /**
     * 转账金额;单位元，保留两位小数
     */
    @NotBlank
    private String amount;

    /**
     * 备注
     */
    @NotBlank
    private String content;

    @Override
    public Class<TransferAccountsResponse> getResponseClass() {
        return TransferAccountsResponse.class;
    }
}