/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.vbill.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.vbill.sdk.BaseVbillResponse;
import com.fshows.vbill.sdk.DefaultHttpRequest;
import com.fshows.vbill.sdk.DefaultSigner;
import com.fshows.vbill.sdk.HttpRequest;
import com.fshows.vbill.sdk.Signer;
import com.fshows.vbill.sdk.VbillApiException;
import com.fshows.vbill.sdk.VbillBizRequest;
import com.fshows.vbill.sdk.VbillBizResponse;
import com.fshows.vbill.sdk.VbillClient;
import com.fshows.vbill.sdk.util.ValidateUtil;
import com.fshows.vbill.sdk.util.VbillHashMap;
import java.text.MessageFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVbillClient
implements VbillClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultVbillClient.class);
    private static final String SUCCESS_CODE = "0000";
    private Signer signer;
    private HttpRequest httpRequest;
    private String serverUrl;
    private String fubeiPrivateKey;
    private String vbillPublicKey;

    public DefaultVbillClient() {
    }

    public DefaultVbillClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DefaultVbillClient(String serverUrl, Signer signChecker, HttpRequest request, String vbillPublicKey, String fubeiPrivateKey) {
        this.signer = signChecker;
        this.httpRequest = request;
        this.serverUrl = serverUrl;
        this.fubeiPrivateKey = fubeiPrivateKey;
        this.vbillPublicKey = vbillPublicKey;
    }

    public DefaultVbillClient(String serverUrl, String vbillPublicKey, String fubeiPrivateKey) {
        this(serverUrl, new DefaultSigner(), new DefaultHttpRequest(), vbillPublicKey, fubeiPrivateKey);
    }

    @Override
    public <T extends VbillBizResponse> BaseVbillResponse<T> execute(VbillBizRequest<T> request, String orgId, String reqId, String version, boolean isSign, Integer timeout) throws VbillApiException {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long beginTime = System.currentTimeMillis();
        log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u5f00\u59cb reqId={},url={},request={},begin={}", new Object[]{reqId, this.serverUrl, request, beginTime});
        if (this.signer == null) {
            this.signer = new DefaultSigner();
        }
        if (this.httpRequest == null) {
            this.httpRequest = new DefaultHttpRequest();
        }
        if (StringUtils.isBlank((CharSequence)this.fubeiPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.vbillPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.serverUrl)) {
            throw new IllegalArgumentException("api\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
        try {
            VbillHashMap hashMap = new VbillHashMap();
            hashMap.put("orgId", orgId);
            hashMap.put("reqId", StringUtils.isBlank((CharSequence)reqId) ? UUID.randomUUID().toString().replace("-", "") : reqId);
            hashMap.put("timestamp", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            hashMap.put("version", StringUtils.isBlank((CharSequence)version) ? "1.0" : version);
            hashMap.put("signType", "RSA");
            hashMap.put("reqData", JSON.toJSONString(request));
            if (isSign) {
                String sign = this.signer.sign(hashMap, "RSA", this.fubeiPrivateKey);
                hashMap.put("sign", sign);
            }
            String requestData = JSON.toJSONString((Object)hashMap);
            String result = this.httpRequest.post(this.serverUrl, requestData, timeout);
            log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u7ed3\u675f reqId={},url={},request={},response={},cost={}ms", new Object[]{reqId, this.serverUrl, request, result, System.currentTimeMillis() - beginTime});
            JSONObject jsonObject = JSON.parseObject((String)result);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            if (StringUtils.isBlank((CharSequence)code) || !code.equals(SUCCESS_CODE)) {
                throw new VbillApiException(MessageFormat.format("\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38\uff0ccode={0},msg={1}", code, msg));
            }
            if (isSign) {
                String respSign = jsonObject.getString("sign");
                String respSignType = jsonObject.getString("signType");
                if (StringUtils.isBlank((CharSequence)respSign) || StringUtils.isBlank((CharSequence)respSign)) {
                    throw new VbillApiException("\u8fd4\u56de\u7b7e\u540d\u4e3a\u7a7a\u6216\u7b7e\u540d\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d\u4fe1\u606f");
                }
                boolean signCheckResult = this.signer.verifySign(jsonObject.getInnerMap(), respSignType, respSign, this.vbillPublicKey);
                if (!signCheckResult) {
                    throw new VbillApiException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d\u4fe1\u606f");
                }
            }
            BaseVbillResponse<VbillBizResponse> response = new BaseVbillResponse<VbillBizResponse>();
            response.setReqId(jsonObject.getString("reqId"));
            response.setMsg(jsonObject.getString("msg"));
            response.setCode(code);
            response.setOrgId(jsonObject.getString("orgId"));
            response.setRespData((VbillBizResponse)JSON.parseObject((String)jsonObject.getString("respData"), request.getResponseClass()));
            return response;
        }
        catch (Exception ex) {
            throw new VbillApiException(ex.getMessage(), ex);
        }
    }

    @Override
    public <T extends VbillBizResponse> BaseVbillResponse<T> execute(String orgId, String reqId, VbillBizRequest<T> request) throws VbillApiException {
        return this.execute(request, orgId, reqId, null, true, 10000);
    }
}

