/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant.wx;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 微信实名认证-提交申请单响应结果
 *
 * @author
 * @version UmpayWxApplymentCreateResponse.java, v 0.1 2022-03-16 16:08:45
 */
@Data
public class UmpayWxApplymentCreateResponse implements Serializable {

    private static final long serialVersionUID = -2213838555547939932L;


    /**
     * 服务商申请单编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    /**
     * 申请单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "applymentId长度不能超过64")
    private String applymentId;

    /**
     * 失败原因或其他状态
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "remark长度不能超过128")
    private String remark;

    /**
     * 申请单受理状态（1、授权校验失败；2、申请中；3、申请受理失败）
     *
     * (必填)
     */
    @NotNull
    private Integer applymentState;

}