package com.fshows.umpay.sdk.response.machine;

import lombok.Data;

import java.io.Serializable;

/**
 * @author huanghai
 * @version 1.0 UmpayMachineQueryResponse
 * @date 2022/4/12 14:28
 */
@Data
public class UmpayMachineQueryResponse implements Serializable {
    private static final long serialVersionUID = -5861856695688397320L;

    /**
     * 终端机具状态
     * 0-库存状态（绑定中）；1-正常状态（绑定成功）；2-挂起状态；3-临时挂起状态；4-报废状态；5-等待二次分拨；6-解绑定；7-绑定中；8-解绑中；
     */
    private String terminalStatus;

    /**
     * 终端厂商编号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则prov_id必填；
     */
    private String provId;

    /**
     * 终端型号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则model_id必填；
     */
    private String modelId;

    /**
     * 终端SN号；可以为TUSN，
     * 若terminal_type<>11-辅助终端，则sn_number必填；
     */
    private String snNumber;

    /**
     * 商户ID
     */
    private String storeId;

    /**
     *机具出库日期
     */
    private String outDate;
    /**
     *机具厂商名称
     */
    private String provName;
    /**
     *机具终端型号名称
     */
    private String modelName;
    /**
     *平台类型：1-支付宝；2-微信；8-银行卡刷卡；
     */
    private String payPlatformType;
    /**
     * 终端设备号
     */
    private String terminalId;
    /**
     * 子商户号
     */
    private String subMchId;
    /**
     * 设备类型
     * 取值范围：
     * 02 传统POS
     * 03 mPOS
     * 04 智能POS
     * 08 手机POS
     * 10 条码支付受理终端
     * 11  辅助终端
     */
    private String terminalType;

    /**
     * 受理终端布放地址的纬度
     * 如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     */
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度
     * 如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     */
    private String terminalGpsLong;
}
