/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.fund;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商户余额查询
 *
 * @author
 * @version UmpayMerchantBalanceQueryResponse.java, v 0.1 2022-03-16 16:31:35
 */
@Data
public class UmpayMerchantBalanceQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555738098199L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * D0余额，商户当天交易产生的款项
     *
     * (必填)
     */
    @NotNull
    private BigDecimal d0Amount;

    /**
     * 账户总余额
     *
     * (必填)
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 在途金额，商户打款中的款项
     *
     * (必填)
     */
    @NotNull
    private BigDecimal processAmount;

    /**
     * 冻结金额，商户未分账款项
     *
     * (必填)
     */
    @NotNull
    private BigDecimal frozenAmount;

    /**
     * 营销账户金额
     *
     * (必填)
     */
    @NotNull
    private BigDecimal offersAmount;

}