package com.fshows.umpay.sdk.response.coupon;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author liangyuanping
 * @version LiquidationWriteOffCouponResponse.java, v 0.1 2022-12-01 2:36 PM
 */
@Data
public class UmpayWriteOffCouponResponse implements Serializable {

    private static final long serialVersionUID = 5552979164076386308L;

    /**
     * 聚合收单平台为商户分配的惟一 ID,商户入驻后由平台返回
     */
    private String storeId;
    /**
     * 服务商解冻单号
     */
    private String outWriteoffNo;
    /**
     * 聚合收单平台解冻单号，在系统内唯一
     */
    private String writeoffNo;
    /**
     * 聚合清算购券单号
     */
    private String orderSn;
    /**
     * 服务商购券单号
     */
    private String outOrderSn;
    /**
     * 解冻状态
     * 1-解冻成功；
     */
    private Integer writeoffStatus;
    /**
     * 解冻金额，单位：元，精确到小数点后两位，取值范围[0.01,100000000]
     */
    private BigDecimal amount;
    /**
     * 解冻净额
     */
    private BigDecimal netMoney;
    /**
     * 补贴金额，单位元
     */
    private BigDecimal subsidyFee;
    /**
     * 解冻完成时间，成功时返回
     * 格式为yyyy-MM-dd HH:mm:ss，如2009年12月25日9点10分10秒表示为2009-12-25 09:10:10
     */
    private String writeoffClose;
    /**
     * 剩余可解冻交易金额
     */
    private BigDecimal restRealMoney;
    /**
     * 剩余可解冻补贴金
     */
    private BigDecimal restSubsidyFee;
}