/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.activity;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 支付宝活动报名接口
 *
 * @author
 * @version UmpayAlipayActivityApplyResponse.java, v 0.1 2022-03-16 16:45:17
 */
@Data
public class UmpayAlipayActivityApplyResponse implements Serializable {

    private static final long serialVersionUID = -2213838555312898646L;


    /**
     * 报名单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

}