/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderRefundResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 订单退款申请
 *
 * @author
 * @version UmpayOrderRefundRequest.java, v 0.1 2022-03-16 14:21:58
 */
@Data
public class UmpayOrderRefundRequest extends UmBizRequest<UmpayOrderRefundResponse> {

    private static final long serialVersionUID = -2213838555698330901L;


    /**
     * 服务商的订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中唯一
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台的订单号,在支付平台中唯一out_trade_no和trade_no二选一必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 服务商外部退款号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 退款金额，不填写视为全额退款
     * <p>
     * (选填)
     */
    @Length(max = 9, message = "refundFee长度不能超过9")
    private String refundFee;

    @Length(max = 256, message = "refundReason长度不能超过256")
    private String refundReason;

    /**
     * 退款手续费，单位：元
     *后记帐模式订单必传
     */
    private BigDecimal refundMerchantFee;

    /**
     * 退款补贴金，单位：元
     * 后记帐模式订单必传
     */
    private BigDecimal refundSubsidy;

    /**
    * 退款回调地址
    */
    @Length(max = 255,message = "退款回调地址长度超过限制")
    private String refundNotifyUrl;

    @Override
    public Class<UmpayOrderRefundResponse> getResponseClass() {
        return UmpayOrderRefundResponse.class;
    }
}