/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author
 * @version UmpayOrderQueryRequest.java, v 0.1 2022-03-16 14:09:59
 */
@Data
public class UmpayOrderQueryRequest extends UmBizRequest<UmpayOrderQueryResponse> {

    private static final long serialVersionUID = -2213838555707910492L;


    /**
     * 服务商订单号，out_trade_no和trade_no不能同时为空；trade_no和out_trade_no如果同时存在优先取trade_no
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台的订单号,在平台中唯一，out_trade_no和trade_no不能同时为空
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    @Override
    public Class<UmpayOrderQueryResponse> getResponseClass() {
        return UmpayOrderQueryResponse.class;
    }
}