/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.terminal;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.terminal.UmpayTerminalBindOrUnbindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * POS终端绑定/解绑
 *
 * @author
 * @version UmpayTerminalBindOrUnbindRequest.java, v 0.1 2022-03-16 16:24:20
 */
@Data
public class UmpayTerminalBindOrUnbindRequest extends UmBizRequest<UmpayTerminalBindOrUnbindResponse> {

    private static final long serialVersionUID = -2213838555829260263L;


    /**
     * 商户ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 操作类型0-pos终端绑定；1-pos终端解绑
     *
     * (必填)
     */
    @NotNull
    private Integer bindType;

    /**
     * 终端厂商编号，联系聚合平台运营人员；若terminal_type&lt;&gt;11-辅助终端，则prov_id必填；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 3, message = "provId长度不能超过3")
    private String provId;

    /**
     * 终端型号，联系聚合平台运营人员；若terminal_type&lt;&gt;11-辅助终端，则model_id必填；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "modelId长度不能超过4")
    private String modelId;

    /**
     * 终端SN号；若terminal_type&lt;&gt;11-辅助终端，则sn_number必填；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "snNumber长度不能超过64")
    private String snNumber;

    /**
     * 装机地的省编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     *
     * (选填)
     */
    @Length(max = 6, message = "installProvinceCode长度不能超过6")
    private String installProvinceCode;

    /**
     * 装机地的市编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     *
     * (选填)
     */
    @Length(max = 6, message = "installCityCode长度不能超过6")
    private String installCityCode;

    /**
     * 装机地的区编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     *
     * (选填)
     */
    @Length(max = 6, message = "installAreaCode长度不能超过6")
    private String installAreaCode;

    /**
     * 装机详细地址，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     *
     * (选填)
     */
    @Length(max = 32, message = "installAddress长度不能超过32")
    private String installAddress;

    /**
     * 子商户号，当一个商户存在多个子商户号时必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 支付平台：1-支付宝；2-微信；8-银行卡刷卡；默认8-银行卡刷卡；
     *
     * (选填)
     */
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 设备类型取值范围：取值 取值说明02 传统POS03 mPOS04 智能POS08 手机POS10 条码支付受理终端11 辅助终端默认：10 条码支付受理终端；
     *
     * (选填)
     */
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端设备号；当bind_type=1-pos终端解绑时，terminal_id和（prov_id、model_id、sn_number）二选一必填；
     *
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 受理终端布放地址的纬度如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLat长度不能超过32")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLong长度不能超过32")
    private String terminalGpsLong;

    @Override
    public Class<UmpayTerminalBindOrUnbindResponse> getResponseClass() {
        return UmpayTerminalBindOrUnbindResponse.class;
    }

}