/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.request.merchant.item.wx.SubMchIdItemRequest;
import com.fshows.umpay.sdk.response.merchant.wx.AggregationSubmerchantUpdateResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author youmingming
 * @version AggregationSubmerchantUpdate.java, v 0.1 2022-05-15 10:01 PM youmingming
 */
@Data
public class AggregationSubmerchantUpdateRequest extends UmBizRequest<AggregationSubmerchantUpdateResponse> {

    private static final long serialVersionUID = -1339265961946291993L;

    /**
     * 聚合平台商户号
     */
    @NotBlank(message = "聚合平台商户号不能为空")
    private String storeId;

    /**
     * 子商户号信息
     */
    private List<SubMchIdItemRequest> subMchIds;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<AggregationSubmerchantUpdateResponse> getResponseClass() {
        return AggregationSubmerchantUpdateResponse.class;
    }
}