/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.item.wx;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author youmingming
 * @version SubMchIdItemRequest.java, v 0.1 2022-05-15 10:09 PM youmingming
 */
@Data
public class SubMchIdItemRequest implements Serializable {

    private static final long serialVersionUID = -7221214171032553261L;

    /**
     * 1-支付宝；2-微信；
     */
    @NotNull(message = "平台类型不能为空")
    private Integer payPlatformType;

    /**
     * 支付宝、微信子商户号
     */
    private String subMchId;

    /**
     * 商户简称
     */
    private String merchantShortname;

    /**
     * 客服电话
     */
    private String servicePhone;
}