/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayMerchantBalanceQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 商户余额查询
 *
 * @author
 * @version UmpayMerchantBalanceQueryRequest.java, v 0.1 2022-03-16 16:31:35
 */
@Data
public class UmpayMerchantBalanceQueryRequest extends UmBizRequest<UmpayMerchantBalanceQueryResponse> {

    private static final long serialVersionUID = -2213838555888679403L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻成功后由平台返回
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    @Override
    public Class<UmpayMerchantBalanceQueryResponse> getResponseClass() {
        return UmpayMerchantBalanceQueryResponse.class;
    }
}