/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayDrawApplyResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 发起提现申请
 *
 * @author
 * @version UmpayDrawApplyRequest.java, v 0.1 2022-03-16 16:36:39
 */
@Data
public class UmpayDrawApplyRequest extends UmBizRequest<UmpayDrawApplyResponse> {

    private static final long serialVersionUID = -2213838555222346776L;


    /**
     * 服务商的提现单号
     *
     * (必填)
     */
    @Length(max = 64, message = "outDrawNo长度不能超过64")
    private String outDrawNo;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻成功后由平台返回
     *
     * (必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 提现类型：0-D0提现；1-D1提现；2-营销账户提现示例：1
     *
     * (必填)
     */
    @NotNull
    private Integer drawType;

    /**
     * 提现金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000]
     *
     * (必填)
     */
    @NotNull
    private BigDecimal drawAmount;

    /**
     * 提现手续费，单位为元，精确到小数点后两位，取值范围[0,100000000]
     *
     * (必填)
     */
    @NotNull
    private BigDecimal drawFee;

    /**
     * 支付成功后回调地址，如果不填会用服务商在聚合收单平台提供的默认地址
     *
     * (选填)
     */
    private String notifyUrl;

    @Override
    public Class<UmpayDrawApplyResponse> getResponseClass() {
        return UmpayDrawApplyResponse.class;
    }
}