/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.coupon;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffReturnQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 解冻退回结果查询
 *
 * @author
 * @version UmpayWriteOffReturnQueryRequest.java, v 0.1 2023-01-31 09:59:35
 */
@Data
public class UmpayWriteOffReturnQueryRequest extends UmBizRequest<UmpayWriteOffReturnQueryResponse> {

    private static final long serialVersionUID = -2213838555132843592L;


    /**
     * 服务商解冻退回单号return_no和out_return_no二选一必填，优先取return_no；
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outReturnNo长度不能超过64")
    private String outReturnNo;

    /**
     * 聚合收单平台解冻退回单号，在系统内唯一return_no和out_return_no二选一必填，优先取return_no；
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "returnNo长度不能超过32")
    private String returnNo;

    @Override
    public Class<UmpayWriteOffReturnQueryResponse> getResponseClass() {
        return UmpayWriteOffReturnQueryResponse.class;
    }
}