/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.dcep.UmpayAggregationEcnyQueryWltRequest;
import com.fshows.umpay.sdk.response.dcep.UmpayAggregationEcnyQueryWltResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version UmpayDcepApiEnum.java, v 0.1 2022-11-16 10:50 PM youmingming
 */
public enum UmpayDcepApiEnum implements UmpayApiDefinition {
    /**
     * 钱包状态查询
     */
    AGGREGATION_ECNY_QUERY_WLT("钱包状态查询",
            "aggregation.ecny.query.wlt",
            UmpayAggregationEcnyQueryWltRequest.class,
            UmpayAggregationEcnyQueryWltResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmpayDcepApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmpayDcepApiEnum getByValue(String value) {
        UmpayDcepApiEnum[] valueList = UmpayDcepApiEnum.values();
        for (UmpayDcepApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    /**
     * 获取api方法签名
     *
     * @return
     */
    @Override
    public String getMethod() {
        return value;
    }

    /**
     * 获取api请求参数类型
     *
     * @return
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    /**
     * 获取api响应参数类型
     *
     * @return
     */
    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}