/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.trade.pay.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 风险控制信息
 *
 * @author liluqing
 * @version UmpayRiskInfoResponse.java, v 0.1 2022-03-16 12:13
 */
@Data
public class UmpayRiskInfoResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * IP
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "terminalIp长度不能超过64")
    private String terminalIp;

    /**
     * （付款 APP）设备 GPS 位置，格式为纬度/经度，+表示北纬、东经，-表示南纬、西经。
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "terminalLocation长度不能超过32")
    private String terminalLocation;
}