/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.dcep;

import lombok.Data;

import java.io.Serializable;

/**
 * @author youmingming
 * @version UmpayAggregationEcnyQueryWlt.java, v 0.1 2022-11-16 10:42 PM youmingming
 */
@Data
public class UmpayAggregationEcnyQueryWltResponse implements Serializable {

    private static final long serialVersionUID = 5552979164076386308L;
    /**
     * 钱包等级
     * WL01：一类钱包
     * WL02：二类钱包
     * WL03：三类钱包
     * WL04：四类钱包
     * WL05：五类钱包
     */
    private String walletLevel;

    /**
     * 钱包开立信息
     * 未开立：00
     * 已开立：01
     * 已注销：02
     */
    private String walletOpenFlag;

    /**
     * 是否绑定了指定金融机构的指定类型卡:
     * 是：Y
     * 否：N
     */
    private String bankCardFlag;
}