/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.activity;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 微信活动审核状态查询接口
 *
 * @author
 * @version UmpayWxActivityQueryResponse.java, v 0.1 2022-03-16 16:53:58
 */
@Data
public class UmpayWxActivityQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555415465944L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 微信子商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "subMchId长度不能超过16")
    private String subMchId;

    /**
     * 申请单状态：0-审核中；1-审核通过；2-审核失败
     *
     * (必填)
     */
    @NotNull
    private Integer applicationState;

    /**
     * 失败理由
     *
     * (选填)
     */
    @Length(max = 512, message = "failReason长度不能超过512")
    private String failReason;

    /**
     * 活动生效日期
     *
     * (选填)
     */
    @Length(max = 32, message = "activeDate长度不能超过32")
    private String activeDate;

}