/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayUnionQueryUseridResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 银联云闪付获取用户标识
 *
 * @author
 * @version UmpayUnionQueryUseridRequest.java, v 0.1 2022-03-16 16:18:20
 */
@Data
public class UmpayUnionQueryUseridRequest extends UmBizRequest<UmpayUnionQueryUseridResponse> {

    private static final long serialVersionUID = -2213838555281478196L;


    /**
     * 付款方返回的临时授权码，一次有效
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "userAuthCode长度不能超过32")
    private String userAuthCode;

    /**
     * 默认为UnionPay/1.0 CloudPay
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "appType长度不能超过32")
    private String appType;

    @Override
    public Class<UmpayUnionQueryUseridResponse> getResponseClass() {
        return UmpayUnionQueryUseridResponse.class;
    }
}