/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.picture;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.request.picture.item.FilesUploadDirectBase64ItemRequest;
import com.fshows.umpay.sdk.response.picture.AggregationFilesUploadDirectResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author youmingming
 * @version AggregationFilesUploadDirectBase64Request.java, v 0.1 2022-03-09 10:49 AM youmingming
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AggregationFilesUploadDirectBase64Request extends UmBizRequest<AggregationFilesUploadDirectResponse> {

    private static final long serialVersionUID = -7933096097510368303L;

    /**
     * 待上传文件URL列表,图片格式包括png、jpg、gif
     */
    @JSONField(name = "file_list")
    private List<FilesUploadDirectBase64ItemRequest> fileList;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<AggregationFilesUploadDirectResponse> getResponseClass() {
        return AggregationFilesUploadDirectResponse.class;
    }
}