/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.UmpaySubmerchantBankBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户结算信息变更
 *
 * @author
 * @version UmpaySubmerchantBankBindRequest.java, v 0.1 2022-03-16 15:14:02
 */
@Data
public class UmpaySubmerchantBankBindRequest extends UmBizRequest<UmpaySubmerchantBankBindResponse> {

    private static final long serialVersionUID = -2213838555278991725L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 非法人清算授权书，传&lt;图片批量上传&gt;返回的对应file_id
     * <p>
     * (选填)
     */
    private String authorCertificatePic;

    /**
     * 结算银行卡卡号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "bankCardNo长度不能超过30")
    private String bankCardNo;

    /**
     * 银行卡正面照，传&lt;图片批量上传&gt;返回的对应file_id（账户类型为0-对私时必填）
     * <p>
     * (特殊必填)
     */
    private String bankCardPic;

    /**
     * 结算银行卡开户名，开户名不允许修改，需与入驻平台时的持卡人姓名保持一致
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "cardHolder长度不能超过10")
    private String cardHolder;

    /**
     * 账户类型：1-对公；0-对私
     * <p>
     * (必填)
     */
    @NotNull
    private Integer isPublicAccount;

    /**
     * 结算卡开户行
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 60, message = "openBank长度不能超过60")
    private String openBank;

    /**
     * 开户支行联行号（账户类型为1-对公时必填）
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "unitedBankNo长度不能超过20")
    private String unitedBankNo;

    /**
     * 结算卡类型：1-法人； 0-非法人； 2-企业
     * <p>
     * (必填)
     */
    @NotNull
    private Integer cardType;

    /**
     * 银行开户许可证，传&lt;图片批量上传&gt;返回的对应file_id（账户类型为1-对公时必填）
     * <p>
     * (特殊必填)
     */
    private String settlementAccountCertificatePic;

    @Override
    public Class<UmpaySubmerchantBankBindResponse> getResponseClass() {
        return UmpaySubmerchantBankBindResponse.class;
    }
}