/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.dcep;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.dcep.UmpayAggregationEcnyQueryWltResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author youmingming
 * @version UmpayAggregationEcnyQueryWltRequest.java, v 0.1 2022-11-16 10:45 PM youmingming
 */
@Data
public class UmpayAggregationEcnyQueryWltRequest extends UmBizRequest<UmpayAggregationEcnyQueryWltResponse> {

    private static final long serialVersionUID = -6607587912228044745L;
    /**
     * 手机号电信国家或地区编码
     * 通过手机号查询时候必传
     * 86：大陆
     * 852：香港
     * 65：新加坡
     * 。。。。。
     * 86、852通过uap国内接口发送短信，65通过uap海外接口发送短信
     */
    @NotBlank(message = "手机号区码不能为空")
    private String mblAreaCode;

    /**
     * 手机号城市编码
     * 预留，有些国家需要填写，目前大陆、香港、新加坡暂不输入
     */
    private String mblCityCode;

    /**
     * 开立电子支付账户所用手机号码。
     */
    @NotBlank(message = "手机号不能为空")
    private String mblNo;

    /**
     * 银行卡类型：
     * CT01：储蓄卡
     * CT02：信用卡（暂不支持）
     * CT03：准贷记卡（暂不支持）
     * CT04：:境外卡
     */
    private String bindCardType;

    /**
     * 金融机构编码
     */
    private String agencyCode;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<UmpayAggregationEcnyQueryWltResponse> getResponseClass() {
        return UmpayAggregationEcnyQueryWltResponse.class;
    }
}