/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.order;

import com.fshows.umpay.sdk.request.trade.pay.item.UmpayPromotionDetailRequest;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayAlipayExtendParamsResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayAlipayVoucherDetailResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayFundBillResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayRiskInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author
 * @version UmpayOrderQueryResponse.java, v 0.1 2022-03-16 14:09:59
 */
@Data
public class UmpayOrderQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555437347236L;


    /**
     * 聚合收单平台交易号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 服务商的订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 支付宝、微信订单号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "platformOrderNo长度不能超过64")
    private String platformOrderNo;


    /**
     * 订单金额（单位元）
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 商家交易净收入计算公式：订单总金额 *（1-商户终端费率） + 交易补贴金
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal netMoney;

    /**
     * 支付平台1-支付宝；2-微信；6-云闪付；8-POS；30-数字人民币
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 订单类型，支付成功时返回：1-条码支付；2-native，原生扫码支付；3-JSAPI，公众号支付，服务窗支付；4-小程序支付；6-云闪付JS支付
     * <p>
     * (特殊必填)
     */
    private Integer orderType;

    /**
     * 0-未支付；1-支付成功；2-支付失败；3-退款中；4-退款成功；5-退款失败；6-订单关闭；7-已撤销；8-已冲正；9-撤销中；10-撤销失败；11-冲正中；12-冲正失败；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer payStatus;

    /**
     * 支付完成时间格式为yyyy-MM-ddHH:mm:ss，如2009年12月25日9点10分10秒表示为2009-12-2509:10:10
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "gmtClose长度不能超过32")
    private String gmtClose;

    /**
     * 通道商户号微信、支付宝、银联云闪付的商户商编
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "subMerchantId长度不能超过32")
    private String subMerchantId;

    /**
     * 付款用户id，“微信openid”、“买家支付宝账户ID”、“云闪付user_id”等，当支付成功时返回
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "userId长度不能超过128")
    private String userId;

    /**
     * 聚合收单平台手续费（单位元）
     * <p>
     * (特殊必填)
     */
    private BigDecimal payPlatformFee;

    /**
     * 聚合收单平台手续费率
     * <p>
     * (特殊必填)
     */
    private BigDecimal payPlatformRate;

    /**
     * 服务商手续费接入的服务商交易获得的返佣金额
     * <p>
     * (特殊必填)
     */
    private BigDecimal liquidatorCommissionFee;

    /**
     * 服务商手续费率接入的服务商设置的手续费率
     * <p>
     * (特殊必填)
     */
    private BigDecimal liquidatorCommissionRate;

    /**
     * 交易补贴金额，单位元下游服务商给商户的交易补贴
     * <p>
     * (特殊必填)
     */
    private BigDecimal subsidyFee;

    /**
     * 付款银行，采用字符串类型的银行标识，微信交易时有返回，具体请查看&lt;微信官方文档&gt;
     * <p>
     * (特殊必填)
     */
    @Length(max = 16, message = "bankType长度不能超过16")
    private String bankType;

    /**
     * 交易支付使用的资金渠道，支付宝交易时有返回,具体请查看&lt;支付宝官方文档&gt;
     * <p>
     * (选填)
     */
    private List<UmpayFundBillResponse> fundBillList;

    /**
     * 分账标识；只有分账订单才可调用&lt;分账&gt;接口进行分账0-无需分账；1-分账订单；默认0-无需分账；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer shareOrderType;

    /**
     * 卡类型：0-借记卡；1-贷记卡；2-其他；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer cardType;

    /**
     * 本次交易支付所使用的单品券优惠信息微信格式：[{"promotion_id":"28853435376","name":"平安信用卡1元券","scope":"GLOBAL","type":"COUPON","amount":100,"activity_id":"16049272","wxpay_contribute":100,"merchant_contribute":0,"other_contribute":0}]支付宝格式：[{"goods_id":"STANDARD1026181538"，"goods_name":"雪碧","discount_amount":"100.00","voucher_id":"2015102600073002039000002D5O"}]
     * <p>
     * (特殊必填)
     */
    @Length(max = 1024, message = "discountGoodsDetail长度不能超过1024")
    private String discountGoodsDetail;

    /**
     * 代金券金额（微信）
     * <p>
     * (选填)
     */
    private BigDecimal couponFee;

    /**
     * 应结订单金额（微信支付宝）
     * <p>
     * (选填)
     */
    private BigDecimal receiptAmount;

    /**
     * 买家实付金额（单位元；微信支付宝）
     * <p>
     * (选填)
     */
    private BigDecimal buyerPayAmount;

    /**
     * 支付宝业务拓展参数--花呗分期
     * <p>
     * (特殊必填)
     */
    private UmpayAlipayExtendParamsResponse alipayExtendParams;

    /**
     * 支付宝本交易支付时使用的所有优惠券信息详见&lt;支付宝官方文档&gt;
     * <p>
     * (特殊必填)
     */
    private List<UmpayAlipayVoucherDetailResponse> alipayVoucherDetailList;



    /**
     * 最大分账金额
     * <p>
     * (选填)
     */
    private BigDecimal maxShareAmount;

    /**
     * 支付人信息，目前为付款方钱包号
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "payerinfo长度不能超过64")
    private String payerinfo;

    /**
     * 订单记账模式：0-先记账模式；1-后记账模式；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer syncType;

    /**
     * 是否已上送手续费：0-无需上送；1-未上送；2-已上送；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer merchantFeeType;

    /**
     * 是否已上送补贴金：0-无需上送；1-未上送；2-已上送；
     * <p>
     * (必填)
     */
    @NotNull
    private Integer subsidyFeeType;

    /**
     * 优惠经费形式：0-预充值；1-免充值
     * <p>
     * (特殊必填)
     */
    @Length(max = 1, message = "offersFeeForm长度不能超过1")
    private String offersFeeForm;

    /**
     * 优惠金额扣款来源：0-本店；1-总店从本商户营销账户扣款 或 从总店营销账户扣款
     * <p>
     * (特殊必填)
     */
    @Length(max = 1, message = "offersFeeSource长度不能超过1")
    private String offersFeeSource;

    /**
     * 优惠金额，单位元给顾客的优惠金额
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal offersFee;

    /**
     * 交易类型
     */
    private String payType;

    /**
     * 聚合收单平台为商户分配的唯一ID
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    @NotBlank
    @Length(max = 20, message = "商户编号长度不能超过20")
    private String merchantId;

    /**
     * 发卡行名称
     */
    @Length(max = 128, message = "发卡行长度不能超过128")
    private String bankName;

    /**
     * pos批次号
     */
    @Length(max = 10, message = "pos批次号长度不能超过10")
    private String posBatchNo;

    /**
     * pos流水号
     */
    @Length(max = 16, message = "pos流水号长度不能超过16")
    private String posTraceNo;

    /**
     * 机具信息
     * 格式：厂商型号|机具型号|SN号
     */
    private String deviceInfo;

    /**
     * 风险控制信息
     * <p>
     * (选填)
     */
    private UmpayRiskInfoResponse riskInfo;

    /**********************************支付宝特有业务字段*********************************/

    /**
     * 平台优惠金额 （支付宝）
     * <p>
     * (选填)
     */
    @Length(max = 11, message = "平台优惠金额长度不能超过11")
    private BigDecimal discountAmount;

    /**
     * 商家优惠金额 （支付宝）
     * <p>
     * (选填)
     */
    @Length(max = 11, message = "商家优惠金额长度不能超过11")
    private BigDecimal mdiscountAmount;

    /**
     * 参与优惠计算的金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000]。 如果该值未传入，但传入了【订单总金额】和【不可打折金额】，则该值默认为【订单总金额】-【不可打折金额】
     */
    @Length(max = 11, message = "参与优惠计算的金额长度不能超过11")
    private BigDecimal discountableAmount;

    /**
     * 不参与优惠计算的金额，单位为元，精确到小数点后两位，取值范围 [0.01,100000000]。如果该值未传入，但传入了【订单总金额】和【可打折金额】，则该值默认为【订单总金额】-【可打折金额】
     */
    @Length(max = 11, message = "不参与优惠计算的金额长度不能超过11")
    private BigDecimal unDiscountableAmount;

     //数币优惠信息

    /**
     * 数币优惠信息
     */
    private List<UmpayPromotionDetailRequest> promotionDetail;

    /**
     * 数币营销补贴金额
     */
    private BigDecimal ecnyAmount;

    //数币优惠信息

}