/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.pay;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.pay.UmpayGetWxFaceAuthInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author
 * @version UmpayGetWxFaceAuthInfoRequest.java, v 0.1 2022-03-16 13:59:00
 */
@Data
public class UmpayGetWxFaceAuthInfoRequest extends UmBizRequest<UmpayGetWxFaceAuthInfoResponse> {

    private static final long serialVersionUID = -2213838555471009836L;


    /**
     * 聚合收单平台为商户分配的惟一 ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeId长度不能超过32")
    private String storeId;

    /**
     * (特殊必填)
     */
    @Length(max = 32, message = "storeNo长度不能超过32")
    private String storeNo;

    /**
     * (特殊必填)
     */
    @Length(max = 32, message = "storeName长度不能超过32")
    private String storeName;

    /**
     * 终端设备编号，由商户定义
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "deviceId长度不能超过32")
    private String deviceId;

    /**
     * 附加字段，字段格式使用Json
     * <p>
     * (选填)
     */
    private String attach;

    /**
     * 初始化数据，由微信人脸SDK的接口返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 2048, message = "rawdata长度不能超过2048")
    private String rawdata;

    /**
     * 子商户公众账号 ID
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 微信子商户号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    @Override
    public Class<UmpayGetWxFaceAuthInfoResponse> getResponseClass() {
        return UmpayGetWxFaceAuthInfoResponse.class;
    }
}