/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxPayConfigQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author cll
 * @version UmpayWxPayConfigQueryRequest.java, v 0.1 2022-06-13 16:00:09 cll
 */
@Data
public class UmpayWxPayConfigQueryRequest extends UmBizRequest<UmpayWxPayConfigQueryResponse> {

    private static final long serialVersionUID = -2213838555624339016L;

    /**
     * 微信子商户号
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    @Override
    public Class<UmpayWxPayConfigQueryResponse> getResponseClass() {
        return UmpayWxPayConfigQueryResponse.class;
    }
}