/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.terminal.UmpayTerminalBandQueryRequest;
import com.fshows.umpay.sdk.request.terminal.UmpayTerminalBindOrUnbindRequest;
import com.fshows.umpay.sdk.response.terminal.UmpayTerminalBandQueryResponse;
import com.fshows.umpay.sdk.response.terminal.UmpayTerminalBindOrUnbindResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 商户终端设备API枚举
 *
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmTerminalApiEnum implements UmpayApiDefinition {

    // 硬件相关
    TERMINAL_BIND_OR_UNBIND(
            "POS终端绑定/解绑",
            "terminal.bind.or.unbind",
            UmpayTerminalBindOrUnbindRequest.class,
            UmpayTerminalBindOrUnbindResponse.class
    ),
    TERMINAL_BAND_STATUS_QUERY(
            "POS绑定状态查询",
            "terminal.band.status.query",
            UmpayTerminalBandQueryRequest.class,
            UmpayTerminalBandQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmTerminalApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmTerminalApiEnum getByValue(String value) {
        UmTerminalApiEnum[] valueList = UmTerminalApiEnum.values();
        for (UmTerminalApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}