/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.picture.AggregationFilesBatchQueryRequest;
import com.fshows.umpay.sdk.request.picture.AggregationFilesUploadDirectBase64Request;
import com.fshows.umpay.sdk.request.picture.AggregationFilesUploadDirectRequest;
import com.fshows.umpay.sdk.response.picture.AggregationFilesBatchQueryResponse;
import com.fshows.umpay.sdk.response.picture.AggregationFilesUploadDirectResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version UmPictureApiEnum.java, v 0.1 2022-02-10 上午9:51 youmingming
 */
public enum UmPictureApiEnum implements UmpayApiDefinition {
    AGGREGATION_FILES_UPLOAD_DIRECT(
            "图片批量上传",
            "aggregation.files.upload.direct",
            AggregationFilesUploadDirectRequest.class,
            AggregationFilesUploadDirectResponse.class
    ),
    AGGREGATION_FILES_UPLOAD_DIRECT_BASE64(
            "图片批量上传",
            "aggregation.files.upload.direct.base64",
            AggregationFilesUploadDirectBase64Request.class,
            AggregationFilesUploadDirectResponse.class
    ),
    AGGREGATION_FILES_BATCH_QUERY(
            "图片批量查询",
            "liquidation.file.query",
            AggregationFilesBatchQueryRequest.class,
            AggregationFilesBatchQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmPictureApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmPictureApiEnum getByValue(String value) {
        UmPictureApiEnum[] valueList = UmPictureApiEnum.values();
        for (UmPictureApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}