/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.merchant.wx;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信配置
 *
 * @author cll
 * @version UmpayWxPayConfigQueryResponse.java, v 0.1 2022-06-13 16:00 cll
 */
@Data
public class UmpayWxPayConfigQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 业务结果
     * SUCCESS/FAIL
     */
    private String resultCode;

    /**
     * 错误代码
     * result_code=FAIL时返回
     */
    private String errCode;

    /**
     * 错误代码描述
     * result_code=FAIL时返回
     */
    private String errCodeDes;

    /**
     * 支付授权目录
     * 银行特约商户公众账号JS API支付授权目录列表 ，JSON格式数据，每个支付目录 要求符合URI格式规范，最多返回5
     * result_code=SUCCESS时返回
     */
    private String jsapiPathList;

    /**
     * 关联APPID与关注
     * sub_appid为绑定好的商户公众号、小程序、APP支付等APPID；
     * subscribe_appid关注特约商户公众号的APPID；
     * 配置关系如果绑定多个以列表形式返回，如果不区分绑定则sub_appid=NULL的记录返回默认推荐关注的APPID
     * result_code=SUCCESS时返回
     */
    private String appidConfigList;
}