/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.picture;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.picture.AggregationFilesBatchQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 图片批量查询
 *
 * @author
 * @version AggregationFilesBatchQueryRequest.java, v 0.1 2022-03-16 15:24:53
 */
@Data
public class AggregationFilesBatchQueryRequest extends UmBizRequest<AggregationFilesBatchQueryResponse> {

    private static final long serialVersionUID = -2213838555919425285L;


    /**
     * 图片上传接口返回的file_id列表
     * <p>
     * (必填)
     */
    @NotNull
    private List<String> fileIdList;

    @Override
    public Class<AggregationFilesBatchQueryResponse> getResponseClass() {
        return AggregationFilesBatchQueryResponse.class;
    }
}