/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpaySettlementQueryListResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 结算结果查询
 *
 * @author
 * @version UmpaySettlementQueryRequest.java, v 0.1 2022-03-16 16:33:24
 */
@Data
public class UmpaySettlementQueryRequest extends UmBizRequest<UmpaySettlementQueryListResponse> {

    private static final long serialVersionUID = -1866707222330441430L;


    /**
     * 聚合收单平台为商户分配的唯一ID
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeId长度不能超过32")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "merchantId长度不能超过20")
    private String merchantId;

    /**
     * 结算发起日期（YYYYMMDD）
     * <p>
     * (drawcash_day和bill_id必传其一)
     */
    @Length(max = 32, message = "drawcashDay长度不能超过32")
    private String drawcashDay;

    /**
     * 聚合收单平台的结算单号
     * <p>
     * (drawcash_day和bill_id必传其一)
     */
    @Length(max = 64, message = "billId长度不能超过64")
    private String billId;

    @Override
    public Class<UmpaySettlementQueryListResponse> getResponseClass() {
        return UmpaySettlementQueryListResponse.class;
    }
}