/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayCounterofferBillDownloadResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 提现账单下载
 *
 * @author
 * @version UmpayCounterofferBillDownloadRequest.java, v 0.1 2022-03-16 14:51:18
 */
@Data
public class UmpayCounterofferBillDownloadRequest extends UmBizRequest<UmpayCounterofferBillDownloadResponse> {

    private static final long serialVersionUID = -2213838555848623282L;


    /**
     * 交易产生的日期，格式为：yyyyMMdd，不填写时默认取当前日期的前一日示例:20201218
     * <p>
     * (选填)
     */
    @Length(max = 8, message = "payDay长度不能超过8")
    private String payDay;

    /**
     * 账单类型：2-提现出款账单
     * <p>
     * (必填)
     */
    @NotNull
    private Integer type;

    @Override
    public Class<UmpayCounterofferBillDownloadResponse> getResponseClass() {
        return UmpayCounterofferBillDownloadResponse.class;
    }
}