/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.client.impl;

/**
 * 通联API接口定义
 *
 * @author liluqing
 * @version UmpayApiDefini.java, v 0.1 2022-03-17 15:39
 * @see com.fshows.umpay.sdk.enums.UmActivityApiEnum 活动报名相关API
 * @see com.fshows.umpay.sdk.enums.UmFundApiEnum 资金对账相关API
 * @see com.fshows.umpay.sdk.enums.UmMerchantApiEnum 商户/进件/费率相关API
 * @see com.fshows.umpay.sdk.enums.UmPictureApiEnum 图片上传相关API
 * @see com.fshows.umpay.sdk.enums.UmTerminalApiEnum 商户终端相关API
 * @see com.fshows.umpay.sdk.enums.UmTradeApiEnum 交易相关API
 */
public interface UmpayApiDefinition {

    /**
     * 获取api方法签名
     *
     * @return
     */
    String getMethod();

    /**
     * 获取api请求参数类型
     *
     * @return
     */
    Class getRequestClass();

    /**
     * 获取api响应参数类型
     *
     * @return
     */
    Class getResponseClass();
}